//Created using Ubuntu 14.04 and Scilab 5.5.0
//Time Domain Analysis
clear
num=poly([12.811 18 6.3223],"s","coeff");      //Defines the numerator of the transfer function
den=poly([12.811 18 11.3223 6 1],"s","coeff"); //Defines the denominator of the transfer function 
sl=syslin('c',num,den);                        //Defines the transfer function
t=[0:0.001:25];                                //The time of simulation is set from 0 to 25 seconds
plot2d(t,csim('step',t,sl))                   //It plots the step response of the transfer function sl
xgrid(5,1,7)
xtitle('Time Domain Analysis','Time(sec)',' C (t) ')



//Error Analysis
clear
clc
num=poly([240 120],"s","coeff"); //Defines the numerator of G(s)
den=poly([12 7 1],"s","coeff"); //Defines the denominator of G(s)
G=num/den;                       //Defines G(s)
Ess=1/(1+horner(G,0));           //Evaluates Steady state error for step input
mprintf('The steady state error is')
disp(Ess)

